/*****************************************************************************
** File:        Y8950.h
**
** Author:      Daniel Vik
**
** Description: Emulation of the Y8950 sound chip
**
******************************************************************************
*/
#ifndef Y8950_H
#define Y8950_H

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct Y8950 Y8950;

/* Constructor and destructor */
int y8950Create(Mixer* mixer, UInt32 cpuClock);

int y8950GetState(Y8950* y8950, UInt8* buffer, UInt32 systemTime);
int y8950SetState(Y8950* y8950, UInt8* buffer, UInt32 systemTime);

void y8950Tick(UInt32 cpuClock);

#endif
